
#ifndef _1_CRYS_SEP_ATP_ECC_Acceptance_h_H
#define _1_CRYS_SEP_ATP_ECC_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_RSA_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
	/***********************************************************************
	* Function Name:                                                           
	*  SEPQA_ECC_ECDSA_NonIntegratedSignVerify         
	* 
	* Inputs:
	* KeyGenType - key gen type (generate internally or build keys)
	* DomainID - domain id
	* PublKeyIn_ptr   - The pointer to external public key data.
	* PublKeySizeInBytes -	Size of public key data in bytes (according to EC domain),
	*						it should be equal to 2*modulusSize (CRYS_ECPKI_DomainID_WMDRM10) or 
	*						2*modulusSize + 1byte (other domains).
	* PrivKeyIn_ptr -      Pointer to private key data. 
	* PrivKeySizeInBytes - Size of private key data in bytes. Must be great than null and
	*					   less or equall to EC OrderSizeInBytes.
	* DataIn_ptr - input data
	* DataInSize - input data size
	* SignatureSize - size of the sugnature
	* HashMode - hash mode
	* SignatureSize - the size of signature buffer 
	*				  must be not less than 2*OrderSizeInBytes.
	* FailureFunctionNameOut_ptr - In case that function failures this parameter
	*                              returns the name of the function that failures
	* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
	*
	* Outputs:
	*  CRYSError_t - Function error return                                     
	*
	* Description:
	* This function is qa external application on the SEP, 
	* that executes Acceptance test for ECC ESDSA Sign & Verify
	* Algorithm:  
	*  1. Allocate memory buffers
	*  2. Prepare keys 
	*     a. Generate keys 
	*     or
	*     a. Build the Private Key 
	*     b. Build the Public Key 
	*  3. Call the CRYS_ECDSA_SignInit to init the Sign operation
	*  4. Call the CRYS_ECDSA_SignUpdate - This function is called N times
	*                                        (N = number of blocks in data each block is 16byte)
	*  5. Call the CRYS_ECDSA_SignFinish to complete the sign operation
	*  6. Call the CRYS_ECDSA_VerifyInit to init the verification operation
	*  7. Call the CRYS_ECDSA_VerifyUpdate - This function is called N times
	*                                        (N = number of blocks in data each block is 16byte)
	*  8.Call the CRYS_ECDSA_VerifyFinish to complete the verification operation     
	*  9. Free allocated buffers
	*
	**************************************************************************************/                                
	CRYSError_t SEPQA_ECC_ECDSA_NonIntegratedSignVerify(
		DxUint32_t			      KeyGenType,
		CRYS_ECPKI_DomainID_t     DomainID,
		DxUint8_t			     *PublKeyIn_ptr,       /*in*/									
		DxUint32_t                PublKeySizeInBytes,  /*in*/
		DxUint8_t			     *PrivKeyIn_ptr,     /*in*/
		DxUint32_t                PrivKeySizeInBytes,/*in*/
		CRYS_ECPKI_HASH_OpMode_t  HashMode,
		DxUint8_t				 *DataIn_ptr,
		DxUint32_t                DataInSize,
		DxUint32_t                SignatureSize,
		DxUint8_t                *FailureFunctionNameOut_ptr);

	/***********************************************************************
	* Function Name:                                                           
	*  SEPQA_ECC_ECDSA_IntegratedSignVerify         
	* 
	* Inputs:
	* KeyGenType - key gen type (generate internally or build keys)
	* DomainID - domain id
	* PublKeyIn_ptr   - The pointer to external public key data.
	* PublKeySizeInBytes -	Size of public key data in bytes (according to EC domain),
	*						it should be equal to 2*modulusSize (CRYS_ECPKI_DomainID_WMDRM10) or 
	*						2*modulusSize + 1byte (other domains).
	* PrivKeyIn_ptr -      Pointer to private key data. 
	* PrivKeySizeInBytes - Size of private key data in bytes. Must be great than null and
	*					   less or equall to EC OrderSizeInBytes.
	* DataIn_ptr - input data
	* DataInSize - input data size
	* SignatureSize - size of the sugnature
	* HashMode - hash mode
	* SignatureSize - the size of signature buffer 
	*				  must be not less than 2*OrderSizeInBytes.
	* FailureFunctionNameOut_ptr - In case that function failures this parameter
	*                              returns the name of the function that failures
	*
	* Outputs:
	*  CRYSError_t - Function error return                                     
	*
	* Description:
	* This function is qa external application on the SEP, 
	* that executes Acceptance test for ECC ESDSA Sign & Verify
	* Algorithm:  
	*  1. Allocate memory buffers
	*  2. Prepare keys 
	*     a. Generate keys 
	*     or
	*     a. Build the Private Key 
	*     b. Build the Public Key 
	*  3. Call CRYS_ECDSA_Sign to perform the sign operation
	*  4. Call CRYS_ECDSA_Verify to perform the verification operation   
	*  5. Free allocated buffers
	*
	**************************************************************************************/                                
	CRYSError_t SEPQA_ECC_ECDSA_IntegratedSignVerify(
				DxUint32_t			      KeyGenType,
				CRYS_ECPKI_DomainID_t     DomainID,
				DxUint8_t			     *PublKeyIn_ptr,       /*in*/									
				DxUint32_t                PublKeySizeInBytes,  /*in*/
				DxUint8_t			     *PrivKeyIn_ptr,     /*in*/
				DxUint32_t                PrivKeySizeInBytes,/*in*/
				CRYS_ECPKI_HASH_OpMode_t  HashMode,
				DxUint8_t				 *DataIn_ptr,
				DxUint16_t                DataInSize,
				DxUint32_t                SignatureSize,
				DxUint8_t                *FailureFunctionNameOut_ptr);

	/*********************************************************
	* Function Name:                                                           
	*  SEPQA_ECC_DH        
	* 
	* Inputs:
	* KeyGenType - key gen type (generate internally or build keys)
	* DomainID - domain id
	* PublKeyIn1_ptr   - The pointer to external public key data for user1.
	* PublKeySizeInBytes1 -	Size of public key data in bytes 
	* PublKeyIn2_ptr   - The pointer to external public key data for user2.
	* PublKeySizeInBytes2 -	Size of public key data in bytes 
	* PrivKeyIn1_ptr -      Pointer to private key data for user1. 
	* PrivKeySizeInBytes1 - Size of private key data in bytes. Must be great than null and
	*					   less or equall to EC OrderSizeInBytes.
	* PrivKeyIn2_ptr -      Pointer to private key data for user2. 
	* PrivKeySizeInBytes2 - Size of private key data in bytes. Must be great than null and
	*					   less or equall to EC OrderSizeInBytes.
	* MaxSecretKeySize    = maximal size of the shared secret key
	* FailureFunctionNameOut_ptr - In case that function failures this parameter
	*                              returns the name of the function that failures
	*
	* Outputs:
	*  CRYSError_t - Function error return                                     
	*
	* Description:                                                                      
	* This function is qa external application on the SEP, 
	* that executes Diffie-Hellman key shared secret generation using ECC capabilities
	* Algorithm: 
	* 1. Allocate memory buffers *
	* 2.Build or generate the private and public keys for user 1 using       
	*     a. Generate keys 
	*     or
	*     a. Build the Private Key 
	*     b. Build the Public Key 
	* 3.Build or generate the private and public keys for user 2 using 
	*     a. Generate keys 
	*     or
	*     a. Build the Private Key 
	*     b. Build the Public Key 
	* 4. Call CRYS_ECDH_SVDP_DH  to Create a shared secret 1 for user 1 
	*    using user1 private key and user 2 public key 
	* 5. Call CRYS_ECDH_SVDP_DH  to Create a shared secret 2 for user 2 
	*    using user2 private key and user 1 public key
	* 6. Compare the two secret keys - to verify they are identical
	* 7. Free allocated buffers
	*
	******************************************************************************/                                          
	CRYSError_t SEPQA_ECC_DH(
		DxUint32_t			      KeyGenType,
		CRYS_ECPKI_DomainID_t     DomainID,
		DxUint8_t			     *PublKeyIn1_ptr,       /*in*/									
		DxUint32_t                PublKeySizeInBytes1,  /*in*/
		DxUint8_t			     *PublKeyIn2_ptr,       /*in*/									
		DxUint32_t                PublKeySizeInBytes2,  /*in*/
		DxUint8_t			     *PrivKeyIn1_ptr,     /*in*/
		DxUint32_t                PrivKeySizeInBytes1,/*in*/
		DxUint8_t			     *PrivKeyIn2_ptr,     /*in*/
		DxUint32_t                PrivKeySizeInBytes2,/*in*/
		DxUint32_t                MaxSecretKeySize,
		DxUint8_t                *FailureFunctionNameOut_ptr);


	/*********************************************************
	* Function Name:                                                           
	*  SEPQA_ECC_ElGamal_EncDec        
	* 
	* Inputs:
	* KeyGenType - key gen type (generate internally or build keys)
	* DomainID - domain id
	* PublKeyIn_ptr   - The pointer to external public key data for user1.
	* PublKeySizeInBytes -	Size of public key data in bytes 
	* PrivKeyIn_ptr -      Pointer to private key data for user1. 
	* PrivKeySizeInBytes - Size of private key data in bytes. Must be great than null and
	*					   less or equall to EC OrderSizeInBytes.
	* DataIn_ptr         - input data
	* DataInSize         - data size
	* EncryptedMsgSize   - encrypted message size
	* MaxSecretKeySize    - maximal size of the shared secret key
	* FailureFunctionNameOut_ptr - In case that function failures this parameter
	*                              returns the name of the function that failures
	*
	* Outputs:
	*  CRYSError_t - Function error return                                     
	*
	* Description: 
	* This function is qa external application on the SEP, 
	* that executes El-Gamal algorithm for encryption and decryption
	*
	* Algorithm:  
	* 1. Allocate memory buffers 
	* 2. Prepare keys 
	*     a. Generate keys 
	*     or
	*     a. Build the Private Key 
	*     b. Build the Public Key 
	* 3. Encrypt a block of data using the CRYS_ECPKI_ELGAMAL_Encrypt encryption process
	* 4. Decrypt a block of data using CRYS_ECPKI_ELGAMAL_Decrypt decryption process 
	* 5. Compare the decrypted data to the original data
	*
	******************************************************************************/                                          
	CRYSError_t SEPQA_ECC_ElGamal_EncDec(
		DxUint32_t			      KeyGenType,
		CRYS_ECPKI_DomainID_t    DomainID,
		DxUint8_t			     *PublKeyIn_ptr,       
		DxUint32_t               PublKeySizeInBytes,  
		DxUint8_t			     *PrivKeyIn_ptr,     
		DxUint32_t               PrivKeySizeInBytes,
		DxUint8_t				 *DataIn_ptr,
		DxUint32_t               DataInSize,
		DxUint32_t               EncryptedMsgSize,
		DxUint8_t               *FailureFunctionNameOut_ptr);

	/*********************************************************
	* Function Name:                                                           
	*  SEPQA_ECC_ImportExportKeyPair        
	* 
	* Inputs:
	* KeyGenType - key gen type (generate internally or build keys)
	* DomainID - domain id
	* PublKeyIn_ptr   - The pointer to external public key data for user1.
	* PublKeySizeInBytes -	Size of public key data in bytes 
	* PrivKeyIn_ptr -      Pointer to private key data for user1. 
	* PrivKeySizeInBytes - Size of private key data in bytes. Must be great than null and
	*					   less or equall to EC OrderSizeInBytes.
	* HashMode           - hash mode
	* DataIn_ptr         - input data
	* DataInSize         - data size
	* SignatureSize      - size of signatured msg
	* FailureFunctionNameOut_ptr - In case that function failures this parameter
	*                              returns the name of the function that failures

	*
	* Outputs:
	*  CRYSError_t - Function error return                                     
	*
	* Description:     
	* This function is qa external application on the SEP, 
	* that executes ECC export public key functionality test
	*
	* Algorithm:  
	*  1. Allocate memory buffers 
	*  2. Prepare keys 
	*     a. Generate keys 
	*     or
	*     a. Build the Private Key 
	*     b. Build the Public Key 
	*  3.	Export the public key using CRYS_ECPKI_ExportPublKey
	*  4.	Re-build the exported key using CRYS_ECPKI_Build_PubKey
	*  5.	Sign a massage using the exported public key using CRYS_ECDSA_Sign to perform the sign operation
	*  6.	Verify the message using the appropriate public key using CRYS_ECDSA_Verify
	*      to perform the verification operation
	*  7. Free allocated buffers 
	*
	******************************************************************************/                                          
	CRYSError_t SEPQA_ECC_ImportExportKeyPair(
		DxUint32_t			      KeyGenType,
		CRYS_ECPKI_DomainID_t    DomainID,
		DxUint8_t			     *PublKeyIn_ptr,       
		DxUint32_t               PublKeySizeInBytes,  
		DxUint8_t			     *PrivKeyIn_ptr,     
		DxUint32_t               PrivKeySizeInBytes,
		CRYS_ECPKI_HASH_OpMode_t HashMode,
		DxUint8_t				 *DataIn_ptr,
		DxUint32_t               DataInSize,
		DxUint32_t               SignatureSize,
		DxUint8_t               *FailureFunctionNameOut_ptr);





#ifdef __cplusplus
}
#endif

#endif


